/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier;

import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BeardifierAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierData;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierRigid;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedJigsawJunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class EnhancedBeardifierHelper {
    public static Beardifier forStructuresInChunk(StructureManager structureManager, ChunkPos chunkPos, Beardifier original) {
        ObjectArrayList enhancedBeardifierRigidList = new ObjectArrayList(10);
        ObjectArrayList enhancedJunctionList = new ObjectArrayList(10);
        int chunkMinBlockX = chunkPos.m_45604_();
        int chunkMinBlockZ = chunkPos.m_45605_();
        List structureStarts = structureManager.m_220477_(chunkPos, structure -> structure instanceof YungJigsawStructure);
        for (StructureStart structureStart : structureStarts) {
            EnhancedTerrainAdaptation structureTerrainAdaptation = ((YungJigsawStructure)structureStart.m_226861_()).enhancedTerrainAdaptation;
            int kernelRadius = structureTerrainAdaptation.getKernelRadius();
            for (StructurePiece structurePiece2 : structureStart.m_73602_()) {
                YungJigsawPoolElement yungElement;
                PoolElementStructurePiece poolPiece;
                StructurePoolElement structurePoolElement;
                if (!(structurePiece2 instanceof PoolElementStructurePiece) || !((structurePoolElement = (poolPiece = (PoolElementStructurePiece)structurePiece2).m_209918_()) instanceof YungJigsawPoolElement) || !(yungElement = (YungJigsawPoolElement)structurePoolElement).getEnhancedTerrainAdaptation().isPresent()) continue;
                kernelRadius = Math.max(kernelRadius, yungElement.getEnhancedTerrainAdaptation().get().getKernelRadius());
            }
            int maxKernelRadius = kernelRadius;
            if (maxKernelRadius <= 0) continue;
            List<StructurePiece> nearbyPieces = structureStart.m_73602_().stream().filter(structurePiece -> structurePiece.m_73411_(chunkPos, maxKernelRadius)).toList();
            for (StructurePiece nearbyPiece : nearbyPieces) {
                if (nearbyPiece instanceof PoolElementStructurePiece) {
                    YungJigsawPoolElement yungElement;
                    PoolElementStructurePiece poolElementPiece = (PoolElementStructurePiece)nearbyPiece;
                    StructureTemplatePool.Projection projection = poolElementPiece.m_209918_().m_210539_();
                    EnhancedTerrainAdaptation pieceTerrainAdaptation = structureTerrainAdaptation;
                    StructurePoolElement structurePoolElement = poolElementPiece.m_209918_();
                    if (structurePoolElement instanceof YungJigsawPoolElement && (yungElement = (YungJigsawPoolElement)structurePoolElement).getEnhancedTerrainAdaptation().isPresent()) {
                        pieceTerrainAdaptation = yungElement.getEnhancedTerrainAdaptation().get();
                    }
                    if (pieceTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                    int pieceKernelRadius = pieceTerrainAdaptation.getKernelRadius();
                    if (projection == StructureTemplatePool.Projection.RIGID) {
                        enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(poolElementPiece.m_73547_(), pieceTerrainAdaptation, poolElementPiece.m_72647_()));
                    }
                    for (JigsawJunction jigsawJunction : poolElementPiece.m_72648_()) {
                        int sourceX = jigsawJunction.m_210252_();
                        int sourceZ = jigsawJunction.m_210258_();
                        if (sourceX <= chunkMinBlockX - pieceKernelRadius || sourceZ <= chunkMinBlockZ - pieceKernelRadius || sourceX >= chunkMinBlockX + 15 + pieceKernelRadius || sourceZ >= chunkMinBlockZ + 15 + pieceKernelRadius) continue;
                        enhancedJunctionList.add((Object)new EnhancedJigsawJunction(jigsawJunction, pieceTerrainAdaptation));
                    }
                    continue;
                }
                if (structureTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(nearbyPiece.m_73547_(), structureTerrainAdaptation, 0));
            }
        }
        Beardifier newBeardifier = new Beardifier(((BeardifierAccessor)original).getPieceIterator(), ((BeardifierAccessor)original).getJunctionIterator());
        ((EnhancedBeardifierData)newBeardifier).setEnhancedRigidIterator((ObjectListIterator<EnhancedBeardifierRigid>)enhancedBeardifierRigidList.iterator());
        ((EnhancedBeardifierData)newBeardifier).setEnhancedJunctionIterator((ObjectListIterator<EnhancedJigsawJunction>)enhancedJunctionList.iterator());
        return newBeardifier;
    }

    public static double computeDensity(DensityFunction.FunctionContext ctx, double density, EnhancedBeardifierData data) {
        int x = ctx.m_207115_();
        int y = ctx.m_207114_();
        int z = ctx.m_207113_();
        while (data.getEnhancedRigidIterator() != null && data.getEnhancedRigidIterator().hasNext()) {
            EnhancedBeardifierRigid rigid = (EnhancedBeardifierRigid)data.getEnhancedRigidIterator().next();
            BoundingBox pieceBoundingBox = rigid.pieceBoundingBox();
            int adjustedPieceMinY = pieceBoundingBox.m_162396_();
            EnhancedTerrainAdaptation pieceTerrainAdaptation = rigid.pieceTerrainAdaptation();
            int xDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.m_162395_() - x, x - pieceBoundingBox.m_162399_()));
            int yDistanceToBoundingBox = Math.max(0, Math.max(adjustedPieceMinY - y, y - pieceBoundingBox.m_162400_()));
            int zDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.m_162398_() - z, z - pieceBoundingBox.m_162401_()));
            int yDistanceToAdjustedPieceBottom = y - adjustedPieceMinY;
            double densityFactor = 0.0;
            if (pieceTerrainAdaptation != EnhancedTerrainAdaptation.NONE) {
                densityFactor = pieceTerrainAdaptation.computeDensityFactor(xDistanceToBoundingBox, yDistanceToBoundingBox, zDistanceToBoundingBox, yDistanceToAdjustedPieceBottom) * 0.8;
            }
            density += densityFactor;
        }
        data.getEnhancedRigidIterator().back(Integer.MAX_VALUE);
        while (data.getEnhancedJunctionIterator() != null && data.getEnhancedJunctionIterator().hasNext()) {
            EnhancedJigsawJunction enhancedJigsawJunction = (EnhancedJigsawJunction)data.getEnhancedJunctionIterator().next();
            JigsawJunction jigsawJunction = enhancedJigsawJunction.jigsawJunction();
            EnhancedTerrainAdaptation pieceTerrainAdaptation = enhancedJigsawJunction.pieceTerrainAdaptation();
            int xDistanceToJunction = x - jigsawJunction.m_210252_();
            int yDistanceToJunction = y - jigsawJunction.m_210257_();
            int zDistanceToJunction = z - jigsawJunction.m_210258_();
            density += pieceTerrainAdaptation.computeDensityFactor(xDistanceToJunction, yDistanceToJunction, zDistanceToJunction, yDistanceToJunction) * 0.4;
        }
        data.getEnhancedJunctionIterator().back(Integer.MAX_VALUE);
        return density;
    }
}

